//	TorusGamesCallbacks-Mac.m
//
//	A few platform-dependent functions that the platform-independent code
//	will call to access user interface objects.
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <Cocoa/Cocoa.h>
#import "TorusGames-Common.h"
#import "TorusGamesAppDelegate-Mac.h"
#import "TorusGamesWindowController.h"
#import "GeometryGamesUtilities-Mac-iOS.h"
#import "GeometryGamesUtilities-Common.h"


void SetTorusGamesStatusMessage(
	const Char16	*aText,	//	zero-terminated UTF-16 string
	ColorP3Linear	aColorP3Linear,
	GameType		aGame)
{
	NSString	*theText;

	//	We don't know whether the caller will be freeing aText or not,
	//	so to be safe, let's copy it to an NSString, which ARC will retain.
	theText = GetNSStringFromZeroTerminatedString(aText);
	
	//	Use dispatch_async() rather than dispatch_sync()
	//	to avoid any chance of deadlock, for example if the caller
	//	holds a lock on the ModelData and the main thread
	//	is waiting for a lock on that same ModelData.
	dispatch_async(dispatch_get_main_queue(),
	^{
		id<NSApplicationDelegate>					theApplicationDelegate;
		TorusGamesAppDelegate						*theTorusGamesAppDelegate;
		NSArray<GeometryGamesWindowController *>	*theWindowControllers;
		GeometryGamesWindowController				*theWindowController;
		TorusGamesWindowController					*theTorusGamesWindowController;

		theApplicationDelegate = [NSApp delegate];
		if ([theApplicationDelegate isKindOfClass:[TorusGamesAppDelegate class]])
		{
			theTorusGamesAppDelegate = (TorusGamesAppDelegate *) theApplicationDelegate;
			theWindowControllers = [theTorusGamesAppDelegate geometryGamesWindowControllers];
			
			//	Torus Games currently supports a single window.
			//	If it supported multiple windows, we'd need
			//	to match the ModelData with the corresonding window(s),
			//	perhaps by using some sort of integer "tag".

			theWindowController = [theWindowControllers firstObject];	//	currently only one window controller
			if ([theWindowController isKindOfClass:[TorusGamesWindowController class]])
			{
				theTorusGamesWindowController = (TorusGamesWindowController *) theWindowController;
				[theTorusGamesWindowController setTorusGamesStatusMessage:theText color:aColorP3Linear];
			}
		}
	});
}
